# -*- coding: utf-8 -*-

import sys
import base64
import traceback
import xbmc

class Orionoid(object):

	Instance = None
	Key = 'VW1sQ1UwbEdSV2RTUTBKRlNVVkpaMDlUUWs1SlJYTm5UbWxDUjBsRk1HZFZVMEpMU1VSaloxSnBRVFZKUmtWblZGTkJNa2xGZDJkT2VVSkpTVVZuWjFONVFsaEpSVEJuVVhsQ1JVbEVUV2RYUTBKQw=='
	Location = 'special://home/addons/script.module.orion/lib'

	@classmethod
	def log(self, message, name = True, parameters = None):
		message = str(message)
		if name:
			nameValue = Orionoid.Instance.Name
			if not name == True: nameValue += ' ' + name
			if parameters:
				nameValue += ' ['
				if isinstance(parameters, basestring): nameValue += parameters
				else: nameValue += ', '.join([str(parameter) for parameter in parameters])
				nameValue += ']'
			nameValue += ': '
			message = nameValue + message
		xbmc.log(message, xbmc.LOGERROR)

	@classmethod
	def error(self, message = None, exception = True):
		if exception:
			type, value, traceback = sys.exc_info()
			filename = traceback.tb_frame.f_code.co_filename
			linenumber = traceback.tb_lineno
			name = traceback.tb_frame.f_code.co_name
			errortype = type.__name__
			errormessage = value.message
			if message: message += ' -> '
			else: message = ''
			message += str(errortype) + ' -> ' + str(errormessage)
			parameters = [filename, linenumber, name]
		else:
			parameters = None
		self.log(message = message, name = 'ERROR', parameters = parameters)

	@classmethod
	def instance(self):
		if Orionoid.Instance == None:
			sys.path.append(xbmc.translatePath(Orionoid.Location))
			from orion import Orion
			Orionoid.Instance = Orion(base64.b64decode(base64.b64decode(base64.b64decode(Orionoid.Key))).replace(' ', ''))
		return Orionoid.Instance

	@classmethod
	def streams(self, type, stream, imdb = None, tmdb = None, tvdb = None, trakt = None, season = None, episode = None, count = None):
		try:
			if stream in Orionoid.Instance.streamTypes():
				items = Orionoid.Instance.streams(type = type, streamType = stream, protocolTorrent = Orionoid.Instance.ProtocolMagnet if Orionoid.Instance.StreamTorrent == stream else None, idImdb = imdb, idTmdb = tmdb, idTvdb = tvdb, idTrakt = trakt, numberSeason = season, numberEpisode = episode, details = True)
				items = items['streams']
				items = [Orionoid.item(item = item, count = count) for item in items]
				return items
		except:
			self.error()
			return None

	@classmethod
	def item(self, item, count = None):
		try:
			torrent = item['stream']['type'] == Orionoid.Instance.StreamTorrent
			result = {'package' : 'single', 'info' : []}

			try:
				link = None
				links = item['links']
				for l in links:
					if l.lower().startswith('magnet:'):
						link = l
						break
				result['magnet' if torrent else 'url'] = link if link else links[0]
			except: return None

			provider = Orionoid.Instance.Name
			try: provider += ' - ' + (item['stream']['source'] if torrent or not item['stream']['hoster'] else item['stream']['hoster'])
			except: pass
			result['provider'] = provider
			result['provider_name_override']  = provider
			result['scraper'] = provider

			try: result['release_title'] = item['file']['name']
			except: result['release_title'] = ''
			try: result['hash'] = item['file']['hash']
			except: result['hash'] = ''
			try:
				try: pack = item['file']['pack']
				except: pack = False
				result['size'] = (item['file']['size'] / 1048576.0) * (count if count and pack else 1)
			except: result['size'] = 0
			try: result['seeds'] = item['stream']['seeds']
			except: result['seeds'] = 0
			try: result['source'] = item['stream']['source'] if torrent or not item['stream']['hoster'] else item['stream']['hoster']
			except: result['source'] = ''
			try: result['direct'] = item['access']['direct']
			except: result['direct'] = False
			try:
				if item['file']['pack']: result['package'] = 'season'
			except: pass
			try:
				if item['video']['3d']: result['info'].append('3D')
			except: pass
			try: result['info'].append(item['video']['codec'].replace('h2', 'x2'))
			except: pass
			try: result['info'].append(item['audio']['system'])
			except:
				try: result['info'].append(item['audio']['codec'])
				except: pass
			try:
				channels = item['audio']['channels']
				if channels == 2: result['info'].append('2.0')
				elif channels == 6: result['info'].append('5.1')
				elif channels == 8: result['info'].append('7.1')
				elif channels == 10: result['info'].append('9.1')
			except: pass
			try: result['info'].append(item['meta']['edition'])
			except: pass
			try: result['info'].append(item['meta']['release'])
			except: pass
			try: result['info'].append(item['meta']['uploader'])
			except: pass
			result['quality'] = 'SD'
			try:
				quality = item['video']['quality']
				if quality in [Orionoid.Instance.QualityHd8k, Orionoid.Instance.QualityHd6k, Orionoid.Instance.QualityHd4k, Orionoid.Instance.QualityHd2k]: result['quality'] = '4K'
				elif quality == Orionoid.Instance.QualityHd1080: result['quality'] = '1080p'
				elif quality == Orionoid.Instance.QualityHd720: result['quality'] = '720p'
				elif not quality == Orionoid.Instance.QualitySd: result['info'].append('CAM')
			except: pass

			# Convert to string, otherwise Seren reorders the items in the list.
			# Must be added as a list, since Seren later appends items to the list.
			result['info'] = [' '.join([i for i in result['info'] if i is not None])]

			result = {k : v for k, v in result.items() if v is not None}
			return result
		except:
			self.error()
			return None
