# -*- coding: utf-8 -*-

import urllib
import urlparse
from ...orionoid import Orionoid

class source: # source, not sources.

	def __init__(self):
		self.orion = Orionoid.instance()

	def movie(self, imdb, title, localtitle, aliases, year):
		try:
			url = {'imdb' : imdb, 'title' : title, 'year' : year}
			return urllib.urlencode(url)
		except: return None

	def tvshow(self, imdb, tvdb, tvshowtitle, localtvshowtitle, aliases, year):
		try:
			url = {'imdb' : imdb, 'tvdb' : tvdb, 'tvshowtitle' : tvshowtitle, 'year' : year}
			return urllib.urlencode(url)
		except: return None

	def episode(self, url, imdb, tvdb, title, premiered, season, episode):
		try:
			if url == None: return
			url = urlparse.parse_qs(url)
			url = dict([(i, url[i][0]) if url[i] else (i, '') for i in url])
			url['title'], url['premiered'], url['season'], url['episode'] = title, premiered, season, episode
			return urllib.urlencode(url)
		except: return None

	def sources(self, url, hostDict, hostprDict):
		try:
			data = urlparse.parse_qs(url)
			data = dict([(i, data[i][0]) if data[i] else (i, '') for i in data])
			if 'tvshowtitle' in data:
				try: count = int(all_info['showInfo']['info']['episodeCount']) / float(all_info['showInfo']['info']['seasonCount'])
				except: count = None
				return Orionoid.streams(type = self.orion.TypeShow, stream = self.orion.StreamHoster, imdb = data['imdb'], season = data['season'], episode = data['episode'], count = count)
			else:
				return Orionoid.streams(type = self.orion.TypeMovie, stream = self.orion.StreamHoster, imdb = data['imdb'])
		except Exception as e:
			Orionoid.error()
			return None
